<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;
                    if (empty($columns)) {
                        $columns = [
                            'Customer Name',
                            'Customer Mobile', 
                             'Amount',
                              'GSTIN',
                             'Email', 
                             'Tag', 
                             'Type', 
                             ' Code', 
                               'Date'
                        ];
                    }
                    $query = "SELECT 
                    u.displayname AS Customer_Name, 
                    u.phoneno AS Customer_Mobile, 
                    u.address AS Address, 
                    u.city AS City, 
                    u.state AS State, 
                    u.pincode AS Pincode,
                    u.email AS Email,
                    u.gstno AS gstin,
                    u.customertype AS Role,
                    u.date AS Create_date,
                    SUM(o.Balance) AS balance_amount
                FROM 
                    customer u
                LEFT JOIN 
                    orders o
                ON 
                    u.id = o.User_id
                WHERE 
                    o.Delete_status = 0
                    AND u.Delete_status = 0";
                
                // Apply duration filters (last week, last month, etc.)
                if ($duration == "Today") {
                    $query .= " AND DATE(u.date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(u.date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND u.date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND u.date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND u.date BETWEEN '$startDate' AND '$endDate'";
                }
                
                // Add GROUP BY clause
                $query .= " GROUP BY 
                u.displayname, u.phoneno, u.address, u.city, u.state, u.pincode, u.email, u.gstno, u.customertype, u.date";

                
                // Perform the query using MySQLi
                $result = $conn->query($query);
                $data = [];
                if ($result) {
                    while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                    }
                }
                
                // Generate the CSV file
                if ($reportFormat == "Xlsx") {
                $filePath = 'reports/customer_report_' . time() . '.csv';
                $file = fopen($filePath, 'w');
                
                // Write the header row
                $header = [];

                // Dynamically add columns to the header using if and switch
                if (in_array('Customer Name', $columns)) $header[] = 'Customer Name';
                if (in_array('Customer Mobile', $columns)) $header[] = 'Customer Mobile';
                if (in_array('Balance Amount', $columns)) $header[] = 'Balance Amount';
                if (in_array('GSTIN', $columns)) $header[] = 'GSTIN';
                if (in_array('Email', $columns)) $header[] = 'Email';
                if (in_array('Tag', $columns)) $header[] = 'Tag';
                if (in_array('Type', $columns)) $header[] = 'Type';
                if (in_array('Referral Code', $columns)) $header[] = 'Referral Code';
                if (in_array('Create Date', $columns)) $header[] = 'Create Date';
                
                // Write the header to the CSV file
                fputcsv($file, $header);
                
                // Write data rows based on the dynamic header
                foreach ($data as $row) {
                    $rowData = [];
                
                    // Use if/switch to dynamically add values to the rowData array
                    if (in_array('Customer Name', $columns)) $rowData[] = isset($row['Customer_Name']) ? $row['Customer_Name'] : '';
                    if (in_array('Customer Mobile', $columns)) $rowData[] = isset($row['Customer_Mobile']) ? $row['Customer_Mobile'] : '';
                    if (in_array('Balance Amount', $columns)) $rowData[] = isset($row['balance_amount']) ? $row['balance_amount'] : '';
                    if (in_array('GSTIN', $columns)) $rowData[] = isset($row['gstin']) ? $row['gstin'] : '';
                    if (in_array('Email', $columns)) $rowData[] = isset($row['Email']) ? $row['Email'] : '';
                    if (in_array('Tag', $columns)) $rowData[] = '';  // Empty for Tag (if not in data)
                    
                    // For 'Type', use a switch statement to handle roles
                    if (in_array('Type', $columns)) {
                        switch ($row['Role']) {
                            case 1:
                                $rowData[] = 'Individual';
                                break;
                            case 2:
                                $rowData[] = 'Business';
                                break;
                            default:
                                $rowData[] = 'Vendor';
                                break;
                        }
                    }
                    
                    if (in_array('Referral Code', $columns)) $rowData[] = '';  // Empty for Referral Code (if not in data)
                    if (in_array('Create Date', $columns)) $rowData[] = isset($row['Create_date']) ? $row['Create_date'] : '';
                
                    // Write the row to the CSV file
                    fputcsv($file, $rowData);
                }
                
                // Close the file
                fclose($file);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                          VALUES ('$reportNo','Customer Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                } elseif ($reportFormat == "pdf") {
                $filePath = 'reports/customer_report_' . time() . '.pdf';
                
                // Create a new PDF document
                $pdf = new FPDF('L', 'mm', array(485, 210));
                
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'B', 12);
                
                // Table headers
                $headers = [
                    'Customer Name',
                    'Customer Mobile',
                    'Balance Amount',
                    'GSTIN',
                    'Email',
                    'Tag',
                    'Type',
                    'Referral Code',
                    'Create Date'
                ];
                
                
                // Set column widths
                $colWidths = array_fill(0, count($headers), 52); // Adjust column widths as needed
                $rowHeight = 8;
                
                // Print header row
                foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                
                // Print data rows
                foreach ($data as $row) {
                    $balance_amount = $row['balance_amount']; // Original value
                if (is_numeric($balance_amount)) {
                    $balance_amount = number_format((float)$balance_amount, 2, '.', ''); // Format to preserve precision
                }
                    $role = ($row['Role'] == 1) ? 'Admin' : (($row['Role'] == 2) ? 'Customer' : 'Other');
                $values = [
                    $row['Customer_Name'],
                  $row['Customer_Mobile'],
                  $balance_amount,
                  $row['gstin'],
                  $row['Email'],    
                  $role,   
                  $role, 
                  '',  
                  $row['Create_date'] 
                ];
                
                foreach ($values as $index => $value) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                }
                
                // Save the PDF file
                $pdf->Output('F', $filePath);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                         VALUES ('$reportNo','Customer Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                } else {
                echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                }
                
                }
            }
?>